var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { collectFiles } from './file/fileCollect.js';
import { processFiles } from './file/fileProcess.js';
import { searchFiles } from './file/fileSearch.js';
import { calculateMetrics } from './metrics/calculateMetrics.js';
import { generateOutput } from './output/outputGenerate.js';
import { copyToClipboardIfEnabled } from './packager/copyToClipboardIfEnabled.js';
import { writeOutputToDisk } from './packager/writeOutputToDisk.js';
import { validateFileSafety } from './security/validateFileSafety.js';
export const pack = (rootDir_1, config_1, ...args_1) => __awaiter(void 0, [rootDir_1, config_1, ...args_1], void 0, function* (rootDir, config, progressCallback = () => { }, deps = {
    searchFiles,
    collectFiles,
    processFiles,
    generateOutput,
    validateFileSafety,
    writeOutputToDisk,
    copyToClipboardIfEnabled,
    calculateMetrics,
}) {
    progressCallback('Searching for files...');
    const { filePaths } = yield deps.searchFiles(rootDir, config);
    progressCallback('Collecting files...');
    const rawFiles = yield deps.collectFiles(filePaths, rootDir);
    const { safeFilePaths, safeRawFiles, suspiciousFilesResults } = yield deps.validateFileSafety(rawFiles, progressCallback, config);
    // Process files (remove comments, etc.)
    progressCallback('Processing files...');
    const processedFiles = yield deps.processFiles(safeRawFiles, config, progressCallback);
    progressCallback('Generating output...');
    const output = yield deps.generateOutput(rootDir, config, processedFiles, safeFilePaths);
    progressCallback('Writing output file...');
    yield deps.writeOutputToDisk(output, config);
    yield deps.copyToClipboardIfEnabled(output, progressCallback, config);
    const metrics = yield deps.calculateMetrics(processedFiles, output, progressCallback, config);
    return Object.assign(Object.assign({}, metrics), { suspiciousFilesResults });
});
//# sourceMappingURL=packager.js.map